
Biojs.AnnotatorEvent = Biojs.Annotator.extend(
/** @lends Biojs.Annotator# */
{
	constructor: function(options){
		
		if (this.opt.proxyUrl == undefined){
			this.opt.proxyUrl= '../biojs/dependencies/proxy/proxy.php';
		}
		
		if (this.opt.allowDuplicates == false){
			this.opt.optimizedVersion = false;
			this.opt.splitted = false;
		}
		
	    this.resetStatus();
	},
	
	 /** 
	    * Default options (and its values) for the Citation component. 
	    * @name Biojs.Citation-opt
	    * @type Object
	    */
	opt: {
		_startSearch : 0,
		_startSearchElaboration : 0
	},
	
	eventTypes : [
	],
	
	//_legendTitle: "EVENTS",
	
	setOptionsFromAncestor: function(ancestorAnnotator, className, sharedData){
		for (prop in ancestorAnnotator.opt) {
		    if (ancestorAnnotator.opt.hasOwnProperty(prop)) {
		        if (prop!="restRdfUrl" && prop!="annotationTypesStart" && prop!="prehighlight"){
		        	
		        	/**if (prop!="idLegend"){
		        		this.opt[prop] = ancestorAnnotator.opt[prop];
		        	}else{
		        		if (ancestorAnnotator.opt.idLegend!=""){
		        			
		        			this.opt.idLegend = ancestorAnnotator.opt.idLegend+"_event";
		        		}
		        	}*/
		        	
		        	this.opt[prop] = ancestorAnnotator.opt[prop];
		        }
		    }
		}
		
		this._dataResultUnselected = ancestorAnnotator._dataResultUnselected;
		this._originalText = ancestorAnnotator._originalText;
		this._className= className;
		this._sharedData = sharedData;
		this.opt.prehighlight=false;
	},
	
	_getAnnotatorTypeLabel: function(){
		return "nactem";
	},
	
   _manipulateResponse: function (){
	  
	    var annotationsNumber=this._annotationsData.length;
	    if (annotationsNumber > 0){
	    	//alert('Size response '+ this._annotationsData.length);
			var indexAnnotation;
	    	for (var i=0; i<annotationsNumber; i++){ 
	    		indexAnnotation = this._annotationsData.length;
	    		this._annotationsData[indexAnnotation]={};
	    		this._annotationsData[indexAnnotation].entity_id = this._annotationsData[i].entity_id;
	    		this._annotationsData[indexAnnotation].uri = this._annotationsData[i].uri;
	    		this._annotationsData[indexAnnotation].annotation = this._annotationsData[i].annotation;
	    		this._annotationsData[indexAnnotation].event_body = this._annotationsData[i].event_body;
	    		this._annotationsData[indexAnnotation].prefix = this._annotationsData[i].e_prefix;
	    		this._annotationsData[indexAnnotation].suffix = this._annotationsData[i].e_postfix;
	    		this._annotationsData[indexAnnotation].exact = this._annotationsData[i].e_exact;
	    		this._annotationsData[indexAnnotation].start = this._annotationsData[i].e_start;
	    		this._annotationsData[indexAnnotation].e_prefix = this._annotationsData[i].prefix;
	    		this._annotationsData[indexAnnotation].e_postfix = this._annotationsData[i].suffix;
	    		this._annotationsData[indexAnnotation].e_exact = this._annotationsData[i].exact;
	    		this._annotationsData[indexAnnotation].e_start = this._annotationsData[i].start;
			}
			
			//alert('Size response after'+ this._annotationsData.length);
		
	    }
			 
	},
	
	_getAnnotationBody: function (annotationData){
		//return annotationData.event_body.value;
		return "";
	},
	
	_getFixedAnnotationsStartup: function (){
		 return [Biojs.AnnotatorBase.PHOSPHORYLATE_NACTEM];
	},
	
	_createAlertMessageDone: function (){
		return 'Annotations loaded from NACTEM totally in '+this._loadingTime+' ms \n Annotations highlighted totally in '+this._timeElapsed+' ms';
	},
	
	_createAlertMessageNoDataFound: function (){ 
		return "No annotations found from NACTEM for the pmcId "+this.opt.pmcId;
	},
	
	_createAlertMessageError: function (){ 
		return "Error calling the NACTEM TRIPLE STORE ";
	},
	
	_postHighlightDone: function(){
		
		if (this.opt.elaborationAnnotation){ 
			var startTime = new Date().getTime();
		    this._mergeDataResult(true, true);
			var endTime = new Date().getTime();
			
		}
		
		if (this.opt.specificId==0){ 
			var intactAnnotator= new Biojs.AnnotatorIntact({});
			intactAnnotator.setOptionsFromAncestor(this, Biojs.AnnotatorBase.CLASSNAME_INTACT, this._sharedData);
			intactAnnotator.load();
		}
		
	},
	
	_elaborateAnnotation: function(annotation, orderInfo){
	     
    	var firstPartAnnotation = annotation.exact.value;
    	var typeAnnotation= this._getAnnotationType(annotation);
		
		this._startSearchElaboration=0;
		if (this.opt.optimizedVersion && (this._indexStartElaboration>0)){
			this._startSearchElaboration = this._indexStartElaboration;
		}

		this._firstFindingElaboration = true;

		indexFound = this._originalText.indexOf(firstPartAnnotation, this._startSearchElaboration);
		
		var previousDataResultLength;
		while(indexFound >0){
			
			if (typeAnnotation==Biojs.AnnotatorBase.PHOSPHORYLATE_NACTEM){
				previousDataResultLength = this._sharedData.getDataResult().length;
				this._elaborateAnnotationPhosphorylate(annotation, orderInfo, indexFound);
				
				if (previousDataResultLength != this._sharedData.getDataResult().length){
					if (this.opt.onlyFirstAnnotation){
						break;
					}
				}
			}
			
			indexFound = this._originalText.indexOf(firstPartAnnotation, this._startSearchElaboration);
		}
		
	},
	
	_elaborateAnnotationPhosphorylate: function(annotation, orderInfo, indexFound){
		var ret = true;
		var firstPartAnnotation = annotation.exact.value;
		var secondPartAnnotation = annotation.e_exact.value;
		var indexFoundSecondPart = this._originalText.indexOf(secondPartAnnotation, indexFound+ firstPartAnnotation.length);
		this._startSearchElaboration = indexFound + firstPartAnnotation.length;
		if (indexFoundSecondPart > 0){
			var textAnnotation = this._getAnnotationText(annotation);
			var textArticleOriginal = this._originalText.substring(indexFound, indexFoundSecondPart + secondPartAnnotation.length);
			var textArticle = this._stripsHTMLTags(textArticleOriginal);
			
			if (textArticle.toLowerCase() == textAnnotation.toLowerCase()){
				var prefixAnnnotation= this._elaboratePreFixAnnotation(annotation.prefix.value);
				var postfixAnnotation= this._elaboratePostFixAnnotation(annotation.e_postfix.value);
				var prefixHTML = this._originalText.substring(0, indexFound);
				var prefixPlain = this._elaboratePreFixHtml(this._stripsHTMLTags(prefixHTML));
				var postfixHTML = this._originalText.substring(indexFoundSecondPart + secondPartAnnotation.length);
				//alert(postfixHTML);
				var postfixPlain = this._elaboratePostFixHtml(this._stripsHTMLTags(postfixHTML));
				
				if (this._isAnnotationMatching(prefixPlain, prefixAnnnotation, postfixPlain, postfixAnnotation)){
					
					if (this._addDataResult(indexFound, indexFound + textArticleOriginal.length, annotation)){
						this._sharedData.incAnnotationFound(Biojs.AnnotatorBase.PHOSPHORYLATE_NACTEM);
					}
					
					this._startSearchElaboration = indexFound + textArticleOriginal.length;
		            
					if (this.opt.optimizedVersion){ 
						if (this._firstFindingElaboration && (this._isToOptimize(orderInfo))){
							this._indexStartElaboration = indexFound;
							this._firstFindingElaboration = false;
						}
					}
					
				}
			}
		}
	},
	
	_highligthAnnotationDirectly: function(originalText, annotation, orderInfo, fromContextualMenu){
		
	    var self = this;
	     
    	var firstPartAnnotation = annotation.exact.value;
    	var type= this._getAnnotationType(annotation);
    	
		var style_class = this._getAnnotationStyle(type);
		
		this._startSearch=0;
		if (this.opt.optimizedVersion && (this._indexStart>0)){
			this._startSearch = this._indexStart;
		}
		var replacement="";
		var idAnnotation;
		var idAnnotationDialog;
		var actionAnnotator= new Biojs.AnnotatorAction({});

		this._firstFinding = true;

		indexFound = originalText.indexOf(firstPartAnnotation, this._startSearch);
		
		var actionAnnotator= new Biojs.AnnotatorAction({});
		
		var originalTextPrevious;
		while(indexFound >0){
			
			if (type==Biojs.AnnotatorBase.PHOSPHORYLATE_NACTEM){
				originalTextPrevious = originalText;
				originalText = this._highligthAnnotationDirectlyPhosphorylate(originalText, annotation, orderInfo, fromContextualMenu, indexFound, actionAnnotator);
				
				if (originalTextPrevious!= originalText){
					if (this.opt.onlyFirstAnnotation){
						break;
					}
				}
			}
			
			indexFound = originalText.indexOf(firstPartAnnotation, this._startSearch);
		}
		
		if (fromContextualMenu){
			var textAnnotation = this._getAnnotationTextSummary(annotation);
			if (this._isAnnotationCompletelyMarked(type, textAnnotation)==false){
				this._annotationsCompletelyMarked[this._annotationsCompletelyMarked.length]= {"type": type, "exact": textAnnotation.toLowerCase()};

			}
			
		}
		
	   return originalText;
	},
	
	_highligthAnnotationDirectlyPhosphorylate: function(originalText, annotation, orderInfo, fromContextualMenu, indexFound, actionAnnotator){
		var ret = true;
		var self= this;
		var firstPartAnnotation = annotation.exact.value;
		var secondPartAnnotation = annotation.e_exact.value;
		var indexFoundSecondPart = originalText.indexOf(secondPartAnnotation, indexFound+ firstPartAnnotation.length);
		this._startSearch = indexFound + firstPartAnnotation.length;
		if (indexFoundSecondPart > 0){
			var textAnnotation = this._getAnnotationText(annotation);
			var textArticleOriginal=originalText.substring(indexFound, indexFoundSecondPart + secondPartAnnotation.length);
			var textArticle = this._stripsHTMLTags(textArticleOriginal);

			if (textArticle.toLowerCase() == textAnnotation.toLowerCase()){
				var prefixAnnnotation= this._elaboratePreFixAnnotation(annotation.prefix.value);
				var postfixAnnotation= this._elaboratePostFixAnnotation(annotation.e_postfix.value);
				var prefixHTML = originalText.substring(0, indexFound);
				var prefixPlain = this._elaboratePreFixHtml(this._stripsHTMLTags(prefixHTML));
				var postfixHTML = originalText.substring(indexFoundSecondPart + secondPartAnnotation.length);
				//alert(postfixHTML);
				var postfixPlain = this._elaboratePostFixHtml(this._stripsHTMLTags(postfixHTML));
				
				if (this._isAnnotationMatching(prefixPlain, prefixAnnnotation, postfixPlain, postfixAnnotation) && (this._isIdAnnotationsMarked(orderInfo)==false) && (this._isDoubledAnnotation(annotation, prefixHTML)==false)){
					
					var style_class= this._getAnnotationStyle(this._getAnnotationType(annotation));
					idAnnotation = "rdf_annotation_event"+orderInfo;
					idAnnotationDialog = idAnnotation+"_dialog";
					replacement = "<span id=\""+idAnnotation+"\" class=\""+style_class+"\">"+textArticleOriginal+"</span><span style=\"display:inline-block;width:0px;height:0px;\" id=\""+idAnnotationDialog+"\"></span>";
					
					this._linkClickSingleAnnotation(actionAnnotator, idAnnotation, [{data: annotation, annotator: self._className, offset: {startIndex: indexFound, endIndex: indexFound + textArticleOriginal.length}}], idAnnotationDialog, orderInfo);
					
					
					originalText = prefixHTML + replacement+postfixHTML;
					this._startSearch = indexFound + replacement.length;
		            
					if (this.opt.optimizedVersion){ 
						if (this._firstFinding && (this._isToOptimize(orderInfo))){
							this._indexStart = indexFound;
							this._firstFinding = false;
						}
					}
					
					this._idAnnotationsMarked[this._idAnnotationsMarked.length]= orderInfo;
				}
			}
		}
		
		return originalText;
	},
	
	_checkAnnotationDiscoverability: function(originalText, annotation){
		
		var firstPartAnnotation = annotation.exact.value;
		var indexFound = originalText.indexOf(firstPartAnnotation, 0);
		var secondPartAnnotation = annotation.e_exact.value; 
		
		while(indexFound >0){
			var indexFoundSecondPart = originalText.indexOf(secondPartAnnotation, indexFound+ firstPartAnnotation.length);
			if (indexFoundSecondPart > 0){
				var textAnnotation = this._getAnnotationText(annotation)
				var textArticle = this._stripsHTMLTags(originalText.substring(indexFound, indexFoundSecondPart + secondPartAnnotation.length));
				
				if (textArticle.toLowerCase() == textAnnotation.toLowerCase()){
					var prefixAnnnotation= this._elaboratePreFixAnnotation(annotation.prefix.value);
					var postfixAnnotation= this._elaboratePostFixAnnotation(annotation.e_postfix.value);
					var prefixHTML = originalText.substring(0, indexFound);
					var prefixPlain = this._elaboratePreFixHtml(this._stripsHTMLTags(prefixHTML));
					var postfixHTML = originalText.substring(indexFoundSecondPart + secondPartAnnotation.length);
					//alert(postfixHTML);
					var postfixPlain = this._elaboratePostFixHtml(this._stripsHTMLTags(postfixHTML));
					
					if (this._isAnnotationMatching(prefixPlain, prefixAnnnotation, postfixPlain, postfixAnnotation)){
						return true;
					}
				}
			}
			
			indexFound = originalText.indexOf(firstPartAnnotation, indexFound + firstPartAnnotation.length);
		}
		
		return false;
	},
	
	_sortAnnotations: function (a,b){
		if (a.start.value <= b.start.value){
			return -1;
		}else{
			return 1;
		}
	},
	
	_getAnnotationType: function (annotation){
		var entityIdValue = annotation.entity_id.value;
		var type_ret=null;
		if (this._startsWith(entityIdValue, "UniProt:")){
			type_ret = Biojs.AnnotatorBase.PHOSPHORYLATE_NACTEM;
		}
		
		return  type_ret;
	},
	
	 _getAnnotationTextSummary: function(annotation){
		var textSummary="";
		var type = this._getAnnotationType(annotation);
		
		if (type==Biojs.AnnotatorBase.PHOSPHORYLATE_NACTEM){
			textSummary = annotation.exact.value+"_"+annotation.e_exact.value;
		}
		return  textSummary;
	},
	
	_getAnnotationText: function (annotation){
		var text="";
		var type = this._getAnnotationType(annotation);
		
		if (type==Biojs.AnnotatorBase.PHOSPHORYLATE_NACTEM){
			var firstPartAnnotation = annotation.exact.value;
			var secondPartAnnotation = annotation.e_exact.value;
			var indexStartAnnotation = annotation.e_prefix.value.lastIndexOf(firstPartAnnotation);
			text = annotation.e_prefix.value.substring(indexStartAnnotation)+ secondPartAnnotation;
		}
		
		return  text;
		
			
	},
	
    _elaboratePostFixAnnotation: function (postfix){
		
		if (this._endsWith(postfix, " ")){
			postfix = postfix.substr(0, postfix.length-1);
		}
		
		var postFixToDelete = "\n     ";
		if (this._endsWith(postfix, postFixToDelete)){
			postfix = postfix.substr(0, postfix.length-(postFixToDelete.length));
		}
	
		if ((this.opt.charactersMatch > 0) && (postfix.length > this.opt.charactersMatch)){
    		return postfix.substr(0, this.opt.charactersMatch);
    	}else{
    		return postfix;
    	}
		
	},
	
	_getAnnotationUrl: function (annotation){
		return annotation.uri.value;
	},
	
	_getAnnotationProvider: function(){
		return "NaCTeM";
	},
	
	_getAnnotationPrefix: function (annotation){
		return annotation.e_prefix.value;
	},
	
	_getAnnotationPostfix: function (annotation){
		return annotation.e_postfix.value;
	},
	
},{
	
});